package gov.va.med.mhv.usermgmt.util;

import org.tigris.atlas.service.BooleanServiceResponse;

import gov.va.med.mhv.core.util.ServiceResponseUtils;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.form.LoginForm;
import gov.va.med.mhv.usermgmt.service.UserProfileServiceResponse;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;

/**
 * A singleton that ensures that authentication is properly audited
 * @author rsimmering
 *
 */
public class Authentication {
	
		private static Authentication instance = new Authentication(); 
		
		public static Authentication getInstance(){
			return instance;
		}
		
        private Authentication(){
        }
        
		public BooleanServiceResponse authenticate(LoginForm form){
            String userName = form.getUserName();
			BooleanServiceResponse response = ServiceDelegateFactory.
                createUserServiceDelegate().authenticate(userName, 
                form.getPassword());
			boolean success = !ServiceResponseUtils.hasErrorMessages(response);
	       
			UserProfileServiceResponse userResponse = ServiceDelegateFactory.
                createUserProfileServiceDelegate().getProfileForUser(userName);
			if((userResponse != null) && 
                (userResponse.getUserProfile() != null))
            {
				Auditor.auditLoginEvent(userResponse.getUserProfile().getId(),
                    ActivityActorTypeEnumeration.SELF, success);
			}
            
			return response;
		}
        
}
